#version 330
#extension GL_EXT_gpu_shader4 : enable
//Mandelbulb attemptMod01.fsh  by Krafpy
//https://www.shadertoy.com/view/sdlGD8
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.5  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define MARCH_STEPS 64  //128.
#define ITERATIONS 16  //32
#define OUTRANGE 2.

mat2 rot(float a){
	return mat2(cos(a), -sin(a),
               sin(a), cos(a));
}

float SDF(vec3 p, out float trap){
    p.xz *= rot(-0.5 + iTime * 0.08);
    p.yz *= rot(-0.5 + iTime * 0.07);
    
    vec3 z = p;
    float n = 8.;
    float r = 0.;
    float dr = 1.;
    
    trap = dot(z,z);
    
    for(int i = 0; i < ITERATIONS; i++){
        r = length(z);
        
        if(r >= OUTRANGE){
            break;
        }
        
        trap = min(dot(z,z), trap);
        
        dr = n * pow(r, n - 1.) * dr + 1.;
        
        float theta = atan(z.y / z.x);
        float phi = asin(z.z / r);

        r = pow(r, n);
        theta *= n;
        phi *= n;
        
        z = r * vec3(cos(theta) * cos(phi), sin(theta) * cos(phi), sin(phi)) + p;
    }
    
    return 0.5 * log(r) * r / dr;
}

float raymarch(vec3 ro, vec3 rd, out float i, out float trap){
    //const float eps = 0.0001;
    
    vec3 p = ro;
    
    // check for bounding sphere
    vec3 cl = p + rd * abs(dot(p, rd));
    if(dot(cl, cl) >= 1.3){
        return -1.;
    }
    
    float t = 0.;
    for(i = 0.; i < MARCH_STEPS; ++i){
        float d = SDF(p, trap);
        float eps = 0.0001 + 0.0001 * t;
        if(d < eps){
            return d;
        }
        t += d;
        p += rd * d;
    }
    
    return -1.;
}

vec3 coloring(float trap){
    trap = clamp(pow(trap, 8.), 0., 1.);
    vec3 col = mix(vec3(1., 0.81, 0.64), vec3(0.8, 0.4, 0.1), trap);
    return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= 0.5;
    uv.x *= iResolution.x / iResolution.y;
    
    float zoom = smoothstep(0., 1., pow(sin(iTime*0.12), 2.));
    vec3 ro = vec3(0.,0.,-2.5) + vec3(0., 0., 1.) * zoom * 1.3;
    vec3 rd = normalize(vec3(uv, 1.));
    
    vec3 col = vec3(0.);
    
    float i;
    float trap;
    float d = raymarch(ro, rd, i, trap);
    
    if(d > 0.){
        col = vec3(1.) * pow(1. - i / MARCH_STEPS, 4.);
        col *= coloring(trap);
    }
    
    gl_FragColor = vec4(col,1.0);
}